;
; ::: airc++ 30621
; ::: a modular script for mIRC
; ::: by Kamek and tabo
;

;;
;
; Very important small functions:
;
;;

; $airc_ver
;   Current script version
alias airc_ver {
  return $read(airc.ver, nt, 1)
}

; $airc_enginever
;   Returns the version of the airc engine
alias airc_enginever {
  return 30621
}

; $airc_vertag
;   Returns "[mircX.XX/aircXXXXX/engineXXXXX]"
alias airc_vertag {
  return $+([mirc, $version, /airc, $airc_ver, /engine, $airc_enginever, ])
}

; $airc_installwin
alias -l airc_installwin {
  return @airc_installwin
}

; /airc_loadremote <file>
;   Loads the file to remotes
;   Right now it just loads the file, but we may want to add more stuff here, like
;   checking for order and things like that
;alias airc_loadremote { .load -rs $+(", $remove($1-, ", $mircdir), ") }
alias -l airc_loadremote {
  if ($aircdebug) {
    .load -rs $+(", $remove($1-, ", $mircdir), ")
  }
  else {
    if (!$window($airc_installwin)) {
      window -hl $airc_installwin
    }
    aline $airc_installwin load $1-
    .timerairc_flushmerge -o 1 0 airc_flushmerge
    if ($script($longfn($1-))) {
      .unload -rs $+(", $ifmatch, ")
    }
  }
}
; ###### <Kamek!20317> added airc_unloadremote
alias -l airc_unloadremote {
  if (!$aircdebug) {
    if (!$window($airc_installwin)) {
      window -hl $airc_installwin
    }
    aline $airc_installwin unload $1-
    .timerairc_flushmerge -o 1 0 airc_flushmerge
  }
  if ($script($longfn($1-))) {
    .unload -rs $+(", $ifmatch, ")
  }
}

; ###### <tabo!20323> this function will handle the "install queue", this means that
;                     it will handle the loading/unloading of script files when the debug
;                     mode is off, also the onload events and if some installed/uninstalled
;                     module had a [hooks] or [settings] section, airc_buildevents will be
;                     called
; ###### <tabo!20718> no longer checking for a [settings] section, this is the
;                     end of mod-specific hacks in the core
; ###### <tabo!20718> moduleload/moduleunload hooks
;
alias airc_flushmerge {
  var %i = 1, %wiw = $airc_installwin, %w1 = @airc_merge, %w2 = @airc_merge_tmp1, %wque = @airc_merge_que, %rfile = $airc_usrdir(modcode.mrc), %file, $&
    %range, %ticks = $ticks, %buildevts = 0, %n, %htmp = airc_flushmerge, %tmp

  if (!$aircdebug) {
    echo $color(info) -qati2 *** Merging modules...
  }
  close -@ %w1 %w2 %wque
  window -hl %w1
  window -hl %w2
  window -hl %wque

  if ($hget(%htmp)) {
    hfree %htmp
  }
  hmake %htmp 10

  if (!$aircdebug && $isfile(%rfile)) {
    loadbuf %w1 %rfile
  }

  ; ###### <tabo!20607> storing the onload events in another tempwin so they
  ;                     will be called _after_ modcode.mrc is created and
  ;                     loaded

  filter -ww %wiw %wque onload *
  filter -cwwx %wiw %wiw onload *

  %n = $line(%wiw, 0)

  while (%i <= %n) {
    var %line = $line(%wiw, %i), %event = $gettok(%line, 1, 32), %parm = $gettok(%line, 2-, 32)
    if (%event == unload) {
      %parm = $longfn(%parm)
      ; ###### <tabo!20323> using relative paths now
      %range = $+($fline(%w1, ; ### begin $remove(%parm, $mircdir), 1), -, $fline(%w1, ; ### end $remove(%parm, $mircdir), 1))
      if (?*-?* iswm %range) {
        dline %w1 %range
      }
      if ($script(%parm)) {
        .unload -rs $+(", $ifmatch, ")
      }
    }
    elseif (%event == load) {
      %parm = $longfn(%parm)
      if ($isfile(%parm)) {
        ; ###### <tabo!20323> using airc_mod2merged
        airc_mod2merged %w2 %w1 %parm
      }
    }

    ; ###### <tabo!20718> moduleload/moduleunload hooks
    elseif ($istok(moduleload moduleunload, %event, 32)) {
      %tmp = $hget(%htmp, %event)
      if ($len(%tmp) < 800) {
        hadd %htmp %event $addtok(%tmp, %parm, 32)
      }
      else {
        aline %wque module*load airc_callhook %event %tmp
        hadd %htmp %event %parm
      }
    }
    elseif (%event == buildevents) {
      inc %buildevts
    }
    inc %i
  }

  if ($hget(%htmp, moduleload) != $null) {
    aline %wque module*load airc_callhook moduleload $ifmatch
  }
  if ($hget(%htmp, moduleunload) != $null) {
    aline %wque module*load airc_callhook moduleunload $ifmatch
  }

  if ($aircdebug) {
    .unload -rs $airc_usrdir(modcode.mrc)
    .remove $airc_usrdir(modcode.mrc)
  }
  else {
    ; save...
    airc_modcode_savereload %w1 $airc_usrdir(modcode.mrc)
  }

  ; rebuild hooks?
  if (%buildevts) {
    airc_buildevents
  }

  ; the temporary queue
  var %i = 1, %n = $line(%wque, 0)
  while (%i <= %n) {
    if ($gettok($line(%wque, %i), 2-, 32) != $null) {
      airc_call $ifmatch
    }
    inc %i
  }

  ; cleanup
  close -@ %w1 %w2 %wque %wiw
  hfree %htmp

  if (!$aircdebug) {
    echo $color(info) -qati2 *** Modules merged in $calc(($ticks - %ticks) / 1000) s
  }
}

; $airc_usrdir([file])
;   If used without parameters, it returns the relative path to the user (profile) directory, where
;   all the user settings are stored.
;   If a file is given, the function returns the path to the file
alias airc_usrdir {
  return usr\default\ $+ $1-
}

; $airc_moddir([file])
;   If used without parameters, it returns the relative path to the modules directory, where all the
;   modules are stored
;   If a file is given, the function returns the path to the file
alias airc_moddir {
  return mod\ $+ $1-
}

; $airc_tmpdir([file])
;   If used without parameters, it returns the relative path to the tmp directory, where all
;   the temporal files are stored. Every mIRC session will have it's own tmp dir, and it will
;   be removed on exit, no module can create a subdir inside the tmpdir
;   If a file is given, the function returns the path to the file
alias airc_tmpdir {
  return $+(tmp\~airc, $window(-2).hwnd, \, $1-)
}

; ###### <Kamek!20106> added $airc_dlldir()
; $airc_dlldir([file], [version])
;   If used without parameters, it returns the general relative path to dlls, where all the
;   dlls are stored
;   If a file is given (version is required then), the function returns the relative path to the file.
alias airc_dlldir {
  if ($1 = $null) {
    return dlls\
  }
  var %d = $iif((*.dll iswm $1), $left($1, -4), $1)
  return $+(dlls\, %d, -, $2, \, %d, .dll)
}

; $airc_datfile
;   Returns the file where the airc options are stored. This file will be /hloaded to
;   airc_htable. Usually the file will be in the user directory. Relative paths only.
alias airc_datfile {
  return $airc_usrdir(airc.dat)
}

; /airc_set <topic> <item> [data]
;   Stores a setting in the main hash table, a $chr(1) character can't be used in the
;   "topic" or in the "item" names because it's used as a separator.
;   If no "data" is given, the item will be removed from the table.
alias airc_set {
  if ($1 == $null) || ($2 == $null) {
    return
  }
  if ($3- != $null) {
    hadd airc_htable $+($1, $chr(1), $2) $3-
  }
  else {
    hdel airc_htable $+($1, $chr(1), $2)
  }
}

; $airc_get(<topic>, <item>)
;   Returns a setting from the main hash table.
alias airc_get {
  return $hget(airc_htable, $+($1, $chr(1), $2))
}


; /airc_datload
;   Loads the airc dat file to airc_htable
alias airc_datload {
  if ($hget(airc_htable)) {
    hfree airc_htable
  }
  hmake airc_htable 20
  if ($isfile($airc_datfile)) {
    hload airc_htable $airc_datfile
  }
}

; /airc_datsave
;   Saves airc_htable to the airc dat file
alias airc_datsave {
  hsave -o airc_htable $airc_datfile
}

; /airc_setsave <topic> <item> [data]
;   Performs a normal /airc_set and then an /airc_datsave
alias airc_setsave {
  airc_set $1-
  airc_datsave
}

; ###### <tabo!20108> added $airc_ishook() and /airc_callhook
; ###### <tabo!20108> the hook aliases will be "airc_hook_name" instead of "hook_name"
; ###### <tabo!20108> we are considering the core as the "airc" module for naming porpuses remember?

; $airc_ishook(<hookname>)
;   Checks if "hookname" exists, returns $true or $false
alias airc_ishook {
  return $isalias($+(airc_hook_, $1))
}

; /airc_callhook <hookname> [parms]
;   Calls a hook (it checks if the hook exists first, so there is no need to use $airc_ishook()
;   everytime a hook is called)
alias airc_callhook {
  if ($isalias($+(airc_hook_, $1))) {
    ; ###### <tabo!20607> now using airc_call, a broken events.mrc could halt the core startup (that's BAD)
    airc_call $+(airc_hook_, $1) $2-
    return $result
  }
  ; this is important for $result
  return
}

; /airc_closedialogs <string>
; /airc_closehtables <string>
; /airc_closetimers  <string>
; /airc_closesockets <string>
;   These functions close the matching dialogs/hash tables/timers/sockets given.
;   Dialogs are closed with the -x flag, so they won't trigger any ok/cancel buttons.
;   NOTE: I put this functions here and not in stdlib.amd because they are used by
;         the airc_uninstall function.
;
alias airc_closedialogs {
  var %i  = 1, %j, %z, %t
  while ($dialog(%i)) {
    var %t = $ifmatch, %j = 1, %z = 1
    while ($gettok($1-, %j, 32) != $null) {
      if ($ifmatch iswm %t) {
        %z = 0
        dialog -x %t
        break
      }
      inc %j
    }
    if (%z) {
      inc %i
    }
  }
}
alias airc_closehtables {
  var %tmp = $1-, %i = $numtok(%tmp, 32)
  while (%i) {
    hfree -w $gettok(%tmp, %i, 32)
    dec %i
  }
}
alias airc_closetimers {
  var %tmp = $1-, %i = $numtok(%tmp, 32)
  while (%i) {
    .timer $+ $gettok(%tmp, %i, 32) off
    dec %i
  }
}
alias airc_closesockets {
  var %tmp = $1-, %i = $numtok(%tmp, 32)
  while (%i) {
    sockclose $gettok(%tmp, %i, 32)
    dec %i
  }
}

; ###### <Kamek!20107> added /airc_call
; ###### <Kamek!20601> now using $_noparse() to avoid re-evaluations
; /airc_call <command>
;   Performs the specified command
alias airc_call {
  .timer.airc_call 1 0 $_noparse($1-) $chr(124) % $+ airc_rval = $!result
  .timer.airc_call -e
  var %rval = %airc_rval
  unset %airc_rval
  return %rval
}

alias _noparse {
  var %i = 1, %t = $numtok($1, 32), %r
  while (%i <= %t) {
    %r = %r $airc_noparse_safetok($gettok($1, %i, 32))
    inc %i
  }
  return %r 
} 

alias -l airc_noparse_safetok { 
  if ($len($1) == 1) {
    if ($istok(35 91 124, $asc($1), 32)) {
      return $!chr( $+ $asc($1) $+ )
    }
    if ($istok(36 37, $asc($1), 32)) {
      return $1
    } 
  } 
  if ($1 == [[ $+ [[) {
    return [[ $+ [[ $!+ [[ $+ [[
  } 
  if ($1 == ]] $+ ]]) {
    return ] $+ ] $!+ ] $+ ]
  } 
  if ($!* iswm $1) {
    return $+($, !, $mid($1, 2))
  }
  if (% $+ * iswm $1) {
    return % $!+ $airc_noparse__safetok($mid($1, 2))
  } 
  return $1 
} 
; M I R C  N E E D S  R E C U R S I O N  B E C A U S E  T H I S  I S  U G L Y
alias -l airc_noparse__safetok {
  return $airc_noparse_safetok($1) 
}

ON *:START:{
  airc_onstart
}
on *:EXIT:{
  airc_callhook exit
  var %x = $findfile($airc_tmpdir, *, 0, .remove $+(", $1-, ")), %x = $finddir($airc_tmpdir, *, 0, 1, airc_deltree $1-)
  .rmdir $airc_tmpdir
}
alias -l airc_deltree {
  var %x = $finddir($1-, *, 0, 1, airc_deltree $1-)
  .rmdir $+(", $1-, ")
}

alias airc_onstart {

  var %ticks = $ticks, %f

  ; first, let's create the usr and mod directories, the scripter is free to modify this
  ; because airc will just call the airc_usrdir and airc_moddir functions
  ; ###### <tabo!20208> now also creating a temp dir
  mkdir usr\
  mkdir $airc_usrdir
  mkdir $airc_moddir
  ; ###### <Kamek!20211> ever wondered you're not deleting those dirs?
  mkdir tmp
  mkdir $airc_tmpdir

  ; now we create our main hash table, airc_htable, and we load the airc.dat file to it
  airc_datload

  ; ###### <tabo!20504> forcing the load of events.mrc (and create a dummy one if needed)
  %f = $airc_usrdir(events.mrc)
  if (!$isfile(%f)) {
    write -c %f 
  }
  if (!$script($+($scriptdir, %f))) {
    .load -rs %f
  }

  ; ###### <tabo!20504> users.mrc & vars.mrc, loading and creating if needed
  %f = $airc_usrdir(users.mrc)
  if (!$isfile(%f)) {
    write -c %f
  }
  if ($readini($mircini, n, rfiles, n0) != %f) {
    .load -ru %f
  }

  %f = $airc_usrdir(vars.mrc)
  if (!$isfile(%f)) {
    write -c %f
  }
  if ($readini($mircini, n, rfiles, n1) != %f) {
    .load -rv %f
  }

  airc_callhook start

  ; ###### <Kamek!20211> unsetting a few vars here... PARANOID
  unset %airc_parms %airc_rval

  all echo $colour(info) -eist *** Startup completed in $+($calc($ticks - %ticks), ms) $airc_vertag
}

;
; /module [flags] [+*|-*]|[[+module|-module] [+module|-module] [...]]
;   "/module +module" to load a module
;   "/module -module" to unload a module
;   "/module +*" to load all the modules
;   "/module -*" to unload all the modules
;   "/module" to show a list of available modules
;   available flags (don't prefix with +):
;     a - automatically load any required modules (for +module)
;     n - don't build events or merge modules (should only be used internally)
;   example: /module a +mod1 +mod2
;
alias module {
  var %flags, %dir = $airc_moddir, %i = 1
  if ($1 == +*) {
    airc_call module + $+ $replace($airc_allmodulesinorder, $chr(32), $+($chr(32), +))
    return
  }
  if ($1 == -*) {
    var %t = $airc_allmodulesinorder, %i = $numtok(%t, 32), %m
    while (%i) {
      %m = %m $+(-, $gettok(%t, %i, 32))
      dec %i
    }
    airc_call module %m
    return
  }
  if ($left($1, 1) !isin +-) {
    %flags = $1
    tokenize 32 $2-
  }
  if ($0 > 1) {
    var %mflags = $+(%flags, $iif(n !isincs %flags, n)), %err
    while (%i <= $0) {
      airc_call module %mflags $($ $+ %i, 2)
      ; error: mass command failed (if you want more descriptive errors, you shouldn't use mass commands)
      if ($result) {
        %err = ERR_MASSFAIL
      }
      inc %i
    }
    if ($timer(airc_flushmerge)) {
      .timerairc_flushmerge -e
    }
    return %err
  }
  var %mod = $right($1, -1), %file = $airc_id2file(%mod)
  if ($1 == $null) {
    linesep -a
    echo $colour(info) -qiat * Modules List
    ; ###### <Kamek!20316> List items aren't shown as "***", but as "*"
    ; ###### <Kamek!20323> The list now shows the version of the module and a [loaded] tag
    ;                      if the module is loaded

    var %dummy = $findfile($airc_moddir, *.amd, 0, 1, echo $colour(info) -qiat * $gettok($nopath($1-), 1, 46) $readini($1-, n, module, version) $iif($airc_get(modules, $gettok($nopath($1-), 1, 46)), [loaded]))
    return
  }
  if ($isfile(%file) == $false) {
    if ($airc_get(modules, %mod)) {
      airc_setsave modules %mod
      echo $colour(ctcp) -qiat *** ERROR: Module $+(', %mod, ') removed from the list, file not found: %file
    }
    else {
      echo $colour(ctcp) -qiat *** ERROR: File not found: %file
    }
    return ERR_NOTFOUND
  }
  else {
    var %missing, %nm, %mmod, %mfile, %mver
    if (+* iswm $1) {
      if (a isincs %flags) {
        if ($istok(%airc_modules, %mod, 32)) {
          echo $color(ctcp) -qiat *** ERROR: Recursive dependency of $+(', %mod, ') detected.
          return ERR_RECURSIVE
        }
        set -u %airc_modules %airc_modules %mod
        %missing = $airc_getmissingmods(%file)
        %nm = 1
        while ($gettok(%missing, %nm, 32)) {
          %mmod = $gettok($ifmatch, 1, 47)
          %mver = $gettok($ifmatch, 2, 47)
          %mfile = $airc_id2file(%mmod)
          if (!$isfile(%mfile)) {
            echo $color(ctcp) -qiat *** ERROR: module $+(', %mod, ') not found
            return ERR_MODNOTFOUND
          }
          elseif ($readini(%mfile, n, module, version) < %mver) {
            echo $color(ctcp) -qiat *** ERROR: module $+(', %mmod, ') is $+(v, $ifmatch, ;) needed v $+ %mver
            return ERR_MODTOOOLD
          }
          airc_call module $+(%flags, $iif((n !isincs %flags), n)) $+(+, %mmod)
          if ($result) {
            return $result
          }
          inc %nm
        }
        if (n !isincs %flags) || (!$airc_get(modules, %mod)) {
          return $airc_install(%file, %flags)
        }
      }
      else {
        return $airc_install(%file, %flags)
      }
    }
    else {
      return $airc_uninstall(%file, %flags)
    }
  }
}

; $airc_modget(N)
;   Returns the id of the Nth loaded module
;   If N is 0, returns the number of loaded modules
alias airc_modget {
  if ($1 == 0) {
    return $hfind(airc_htable, $+(modules, $chr(1), *), $1, w)
  }
  return $gettok($hfind(airc_htable, $+(modules, $chr(1), *), $1, w), 2, 1)
}

; $airc_modisloaded(module)
alias airc_modisloaded {
  return $iif( $hget(airc_htable, $+(modules, $chr(1), $1)) , 1, 0)
}

; $airc_id2file(module)
;   returns the filename for that module (relative path)
alias airc_id2file {
  if (*.amd iswm $1) {
    return $airc_moddir($gettok($nopath($1), 1, 46))
  }
  return $+($airc_moddir($gettok($nopath($1), 1, 46)), .amd)
}

; $airc_check(file, +[svfmd])
;  s - outputs errors to active
;  v - checks if module can be loaded in the current version of the script
;  f - checks if the required files exist
;  m - checks if the required modules are loaded
;  d - checks if the required dlls exist
;  
alias airc_check {
  var %file = $1

  ; General check, this is just to be sure that the file is an airc module
  if ( !$readini(%file, n, module, name) || !$readini(%file, n, module, version) || !$readini(%file, n, module, aircver) || !$readini(%file, n, module, id) ) {
    if (s isincs $2) {
      echo $colour(ctcp) -qiat *** ERROR: Invalid module: $+(', %file, ') - File corrupted
    }
    return ERR_CORRUPT
  }

  ; check if the module can run in the current version of the engine
  if (v isincs $2) {
    var %rv = $readini(%file, n, module, aircver)
    if (!%rv || %rv > $airc_enginever) {
      if (s isincs $2) {
        echo $colour(ctcp) -qiat *** ERROR: Invalid module: $+(', %file, ') - It's for airc %rv
      }
      return ERR_NOFUTURE
    }
  }

  ; check for missing required files and dlls
  var %mfiles
  if (f isincs $2) && ($readini(%file, n, module, reqfiles) != $null) {
    var %tmp = $ifmatch, %i = 1, %tf
    while ($gettok(%tmp, %i, 32)) {
      %tf = $airc_moddir($ifmatch)
      if ( !$isfile(%tf) ) {
        %mfiles = %mfiles %tf
      }
      inc %i
    }
  }

  if (d isincs $2) && ($readini(%file, n, module, reqdlls) != $null) {
    var %tmp = $ifmatch, %i = 1, %tf
    while ($gettok(%tmp, %i, 32)) {
      ; ###### <Kamek!20106> using $airc_dlldir()
      ; ###### <Kamek!20106> do NOT add ".dll" for the dll anymore
      ; ###### <Kamek!20107> new format: dllname/ver dllname/ver ...
      var %tf = $ifmatch, %tm = $gettok(%tf, 1, 47), %tv = $gettok(%tf, 2, 47), %tm = $airc_dlldir(%tm, %tv)
      if ( !$isfile(%tm) ) {
        %mfiles = %mfiles %tf
      }
      inc %i
    }
  }
  if (%mfiles != $null) {
    ; ###### <Kamek!20106> changed this error message... a module isn't invalid just because files are missing.
    ; ###### <Kamek!20106> anyway, it needs improvement.
    ; ###### <Kamek!20106> "Can't load module" isn't good if you're just checking
    if (s isin $2) {
      echo $colour(ctcp) -qiat *** ERROR: Can't load module: $+(", %file, ") - Missing files: %mfiles
    }
    return ERR_NOFILES %mfiles
  }

  ; check if the required modules are loaded
  if (m isincs $2) && ($readini(%file, n, module, reqmods) != $null) {
    var %tmp = $ifmatch, %i = 1
    while ($gettok(%tmp, %i, 32)) {
      var %tf = $ifmatch, %tm = $gettok(%tf, 1, 47), %tv = $gettok(%tf, 2, 47)
      ; ###### <Kamek!20316> it's not ">=", it's "<=" here
      if ($airc_get(modules, %tm)) && (%tv <= $readini($airc_id2file(%tm), n, module, version)) {
        inc %i
        continue
      }
      ; ###### <Kamek!20106> changed this error message... same before, for missing modules
      if (s isin $2) {
        echo $colour(ctcp) -qiat *** ERROR: Can't load module: $+(", %file, ") - Requires module: %tm $iif(%tv, $+(v, %tv) )
      }
      return ERR_NOMOD %tm %tv
    }
  }

  return 0
}

; ###### <Kamek!20316> added airc_getmissingmods function, an 'extended' version of $airc_check() with +m
; $airc_getmissingmods(file)
;   returns a list of all the missing modules for the specified .amd file.
;   for example: mod1/20220 mod2/10907
alias airc_getmissingmods {
  if ($readini($1, n, module, reqmods) != $null) {
    var %tmp = $ifmatch, %i = 1, %missing
    while ($gettok(%tmp, %i, 32)) {
      var %tf = $ifmatch, %tm = $gettok(%tf, 1, 47), %tv = $gettok(%tf, 2, 47)
      if (!$airc_get(modules, %tm)) || (%tv > $readini($airc_id2file(%tm), n, module, version)) {
        %missing = %missing %tf
      }
      inc %i
    }
  }
  return %missing
}

; /airc_install <file>
; $airc_install(file, [flags])
;   flags:
;     ?  - ???
alias airc_install {
  ; ###### <Kamek!20316> added flags for $airc_install()
  var %file = $iif($isid, $1, $1-), %flags = $iif($isid, $2), %id = $gettok($nopath(%file), 1, 46)

  ; ###### <tabo!20108> i'll just stop this here instead of putting everything inside the /if !$... , should save a few bytes
  ; ###### <Kamek!20316> airc_install now has return values.
  if ($airc_check(%file, +svfmd)) {
    return $ifmatch
  }

  if ($airc_get(modules, %id)) {
    echo $colour(ctcp) -qiat *** ERROR: Module already installed: %id
    return ERR_ALREADY
  }
  var %toload = $readini(%file, n, module, scriptfiles), %i = 1, %hide = 0
  while ($gettok(%toload, %i, 32) != $null) {
    airc_loadremote $airc_moddir($ifmatch)
    inc %i
  }
  if (!$window($airc_installwin)) {
    window -hl $airc_installwin
  }
  ; ###### <Kamek!20106> "TODO: what to do", rofl
  ; ###### TODO: what to do here? ######
  ; what should be stored in the module "entry" in the hash table?
  ; right now it's only a placeholder, a "+" character
  ; maybe also the module version?
  airc_setsave modules %id +
  ; ###### <Kamek!20316> we can't call the loading command before compiling modules now.
  ;if ($readini(%file, n, module, onload) != $null) {
  ;  ; ###### <tabo!20108> i still don't like this, i think that we should check for $isalias() here, also in uninstall
  ;  airc_call $ifmatch
  ;  if (s isincs $gettok($result, 1, 32)) { %hide = 1 }
  ;}
  if ($readini(%file, n, module, onload) != $null) {
    aline $airc_installwin onload $readini(%file, n, module, onload)
    .timerairc_flushmerge -o 1 0 airc_flushmerge
  }
  if (h !isincs $readini(%file, n, module, onloadflags)) {
    echo $colour(info) -qiat *** Module Installed: %id $readini(%file, n, module, version)
  }

  if ( $read(%file, nw, [hooks]) ) {
    aline $airc_installwin buildevents +
    .timerairc_flushmerge -o 1 0 airc_flushmerge
  }

  ; ###### <tabo!20718> adding a moduleload event to the install queue
  aline $airc_installwin moduleload %id

  return
}

; /airc_uninstall <file>
; $airc_uninstall(file, [flags])
;   flags:
;     ?  - ???
alias airc_uninstall {
  ; ###### <Kamek!20316> added flags for $airc_uninstall()
  var %file = $iif($isid, $1, $1-), %flags = $iif($isid, $2), %id = $gettok($nopath(%file), 1, 46), %h = airc_htable, %reqs
  if (!$airc_check(%file, +s)) {
    if ($airc_get(modules, %id) == $null) {
      echo $colour(ctcp) -qiat *** ERROR: Module not installed: %id
      return ERR_NOTINSTALLED
    }
  }

  ; we can't unload a module if it's required by another module
  ; the user must unload that other module first
  var %i = $airc_modget(0), %p
  while (%i) {
    %p = $airc_modget(%i)
    ; ###### <tabo!20108> damn it Danie|_! you forgot to update this when you modified the reqmods format to mod/ver
    if (%p != %id) && ($istok($replace($readini($airc_id2file(%p), n, module, reqmods), /, $chr(32)), %id, 32)) {
      %reqs = %reqs %p
    }
    dec %i
  }
  if (%reqs != $null) {
    echo $colour(ctcp) -qiat *** ERROR: Can't unload module %id - It is required by $&
      $iif($numtok(%reqs, 32) == 1, this loaded module:, these loaded modules:) %reqs
    ; "has dependencies"
    return ERR_HASDEPS
  }

  ; ###### <Kamek!20106> it's not [unload] unload, it's [unload] command
  ; ###### <Kamek!20106> damn tabo, you mistyped both load and unload commands!
  ; ###### <tabo!20108>  i suck
  if ($readini(%file, n, unload, command) != $null) {
    airc_call $ifmatch
    if ($result) {
      return
    }
  }
  if ($readini(%file, n, unload, variables) != $null)  {
    unset $ifmatch
  }
  if ($readini(%file, n, unload, dialogs) != $null)    {
    airc_closedialogs $ifmatch
  }
  if ($readini(%file, n, unload, windows) != $null)    {
    close -@ $ifmatch
  }
  if ($readini(%file, n, unload, sockets) != $null)    {
    airc_closesockets $ifmatch
  }
  if ($readini(%file, n, unload, timers) != $null)     {
    airc_closetimers $ifmatch
  }
  if ($readini(%file, n, unload, hashtables) != $null) {
    airc_closehtables $ifmatch
  }

  var %toload = $readini(%file, n, module, scriptfiles), %i = 1
  while ($gettok(%toload, %i, 32) != $null) {
    airc_unloadremote $airc_moddir($ifmatch)
    inc %i
  }
  airc_setsave modules %id
  echo $colour(info) -qiat *** Module Uninstalled: %id

  if (!$window($airc_installwin)) {
    window -hl $airc_installwin
  }

  if ( $read(%file, nw, [hooks]) ) {
    aline $airc_installwin buildevents +
    .timerairc_flushmerge -o 1 0 airc_flushmerge
  }

  ; ###### <tabo!20718> adding a moduleunload event to the install queue
  aline $airc_installwin moduleunload %id

  return
}
; ###### <Kamek!20623> Kamek Productions Inc. present airc_buildevents 2.32!
; ###### <Kamek!20302> also, new flag: +t for input events (means that the command should only be called for text, not commands)
; ###### <tabo!20718> added support for amdsections, no more mod-specific hacks in the core
; ###### <tabo!20718> added support for the moduleload/moduleunload hooks
alias airc_buildevents {
  ; part 1: prepare everything, load events into a @window
  var %wine = @airc_buildeventsEvents, %winc = @airc_buildeventsCode, %i = 1, %j, %plvl, %fn, %ln, $&
    %returnpoint = returnpoint1, %| = $chr(124)
  ; constants
  var %haltdefault = actionchan actionuser ban chat dehelp deop devoice help hotlink invite join kick mode nick notify noticechan noticeuser $&
    op openuser part ping pong textchan textuser rawmode unban usermode voice quit serv servermode snotice topic unotify wallops
  var %suffixedevents = closechat closeserv closeuser ctcpchan ctcpuser actionchan actionuser noticechan noticeuser openchat openserv $&
    openuser textchan textuser inputchan inputchat inputserv inputuser
  var %chanevents = ban dehelp deop devoice help invite join kick mode op part rawmode servermode serverop topic unban voice inputchan
  var %genparmevents = active chat close ctcpreply dccserver error filercvd filesent getfail open sendfail serv snotice wallops input
  var %noparmevents = agent appactive connect disconnect dns exit midiend mp3end nick nosound notify ping playend pong quit unotify $&
    usermode waveend
  var %hasparmidsevents = action chat ctcp ctcpreply error hotlink input kick mode notice open part ping pong quit rawmode serv servermode $&
    snotice text topic usermode vcmd wallops
  ; variables for amdsections
  var %amdsections, %ass, %asu, %asf, %asw, %mod, %linenum, %line


  close -@ %wine %winc
  window -hl %wine
  window -hl %winc

  while ($airc_modget(%i)) {
    %mod = $ifmatch
    %fn = $airc_id2file(%mod)
    if ($read(%fn, nw, [hooks])) {
      loadbuf -thooks %wine %fn
    }

    ; ###### <tabo!20718> loading&merging all the amdsections to @windows,
    ;                     amdsection has its own @window called @airc_buildevents_<section>
    var %ass = $readini(%fn, n, module, amdsections), %j = $numtok(%ass, 32)
    while (%j) {
      var %asu = $gettok(%ass, %j, 32), %asw = $+(@airc_buildevents_, %asu)
      if ($read(%fn, nw, $+([, %asu, ]))) {
        %asf = $airc_usrdir($+(%asu, .dat))
        if (!$istok(%amdsections, %asu, 32)) {
          close -@ %asw
          window -hl %asw
          %amdsections = $addtok(%amdsections, %asu, 32)
        }
        ; ###### <Kamek!20723> prefixing each line with the name of the module,
        ;         taking out comments and blank lines
        ; start from the first line that will be added...
        %linenum = $calc($line(%asw, 0) + 1)
        loadbuf -t $+ %asu %asw %fn
        while (%linenum <= $line(%asw, 0)) {
          set -n %line $gettok($line(%asw, %linenum), 1-, 32)
          if (;* !iswm %line) && (%line != $null) {
            rline %asw %linenum %mod %line
            inc %linenum
          }
          else {
            dline %asw %linenum
          }
        }
      }
      dec %j
    }
    inc %i
  }
  ; now, leave only valid lines (this includes taking out comments)
  filter -cwwg %wine %wine /^[a-zA-Z]+([_a-zA-Z0-9]+)?[ ]+(0[1-9]|[1-9]\d)[ ]+\+[a-zA-Z]*[ ]+.+$/i

  ; add priority levels to the lines (normal lines become "2 <line>", +o lines become "1 <line>", raws are level 9...),
  ; so they're correctly reordered -- don't confuse this with the normal priority from events!
  ; - 1: +o lines
  ; - 2: normal lines (default)
  ; - 3: open, close
  ; - 4: inputchan
  ; - 4.1: inputchan +t (decimals indicate a sub-level)
  ; - 5: inputuser
  ; - 5.1: inputuser +t
  ; - 6: inputchat
  ; - 6.1: inputchat +t
  ; - 7: inputserv
  ; - 7.1: inputserv +t
  ; - 8: input
  ; - 8.1: input +t
  ; - 9: raws
  ; - 10: general raw
  ; - 11: aliases (custom hooks)
  %i = $line(%wine, 0)
  while (%i) {
    %ln = $line(%wine, %i)
    if (raw * iswm %ln) {
      %plvl = 10
    }
    elseif (raw_* iswm %ln) {
      %plvl = 9
    }
    elseif (input * iswm %ln) {
      %plvl = $iif((t isincs $gettok(%ln, 3, 32)), 8.1, 8)
    }
    elseif (inputserv * iswm %ln) {
      %plvl = $iif((t isincs $gettok(%ln, 3, 32)), 7.1, 7)
    }
    elseif (inputchat * iswm %ln) {
      %plvl = $iif((t isincs $gettok(%ln, 3, 32)), 6.1, 6)
    }
    elseif (inputuser * iswm %ln) {
      %plvl = $iif((t isincs $gettok(%ln, 3, 32)), 5.1, 5)
    }
    elseif (inputchan * iswm %ln) {
      %plvl = $iif((t isincs $gettok(%ln, 3, 32)), 4.1, 4)
    }
    elseif (_ isin $gettok(%ln, 1, 32)) {
      %plvl = 14
    }
    elseif ($istok(open close, $gettok(%ln, 1, 32), 32)) {
      %plvl = 3
    }
    ; only prefix with ^ if the remote can be halted
    elseif (o isincs $gettok(%ln, 3, 32)) && ($istok(%haltdefault, $gettok(%ln, 1, 32), 32)) {
      %plvl = 1
    }
    else {
      %plvl = 2
    }
    rline %wine %i %plvl %ln
    dec %i
  }
  ; reorder events
  filter -cwwa %wine %wine airc_buildevents_sort *

  ; part 2: convert hooks into code
  var %a = aline %winc, %e, %le, %cure, %laste, %reale, %i = 1, %j = 2, %t = $line(%wine, 0), %ln, %header, $&
    %open = 0, %isalias = 0, %code, %pcode, %hasparmids, %israw, %has_general_raw, %added_general_hook
  ; look for a general raw hook
  %has_general_raw = $iif(($fline(%wine, & raw *, 1)), 1, 0)
  while (%i <= %t) {
    %ln = $line(%wine, %i)
    %plvl = $int($gettok(%ln, 1, 32))
    ; %cure (current event) is a unique identifier each event+plevel takes
    ; compare it to identifying each channel you're on with "$cid $chan", not just $chan, to avoid problems
    %cure = %plvl $gettok(%ln, 2, 32)
    %ln = $gettok(%ln, 2-, 32)
    %e = $gettok(%ln, 1, 32)
    %code = $gettok(%ln, 4-, 32)
    if (h isincs $gettok(%ln, 3, 32)) {
      %code = if (!$halted) $chr(123) %code $chr(125)
    }
    ; if the event isn't the same from the last one...
    if (%cure != %laste) {
      ; if the tag was open, close it
      if (%open) {
        %le = $gettok(%laste, 2, 32)
        goto close
        :returnpoint1
      }
      if (%e == input) {
        ; if we have an input hook but no inputchan, inputuser, inputchat or inputserv, make blank hooks
        ; just so input is not called for these windows
        if (!$fline(%wine, & inputchan *, 1)) {
          %a on *:input:#: $+ $chr(123) $chr(125)
        }
        if (!$fline(%wine, & inputuser *, 1)) {
          %a on *:input:?: $+ $chr(123) $chr(125)
        }
        if (!$fline(%wine, & inputchat *, 1)) {
          %a on *:input:=: $+ $chr(123) $chr(125)
        }
        if (!$fline(%wine, & inputserv *, 1)) {
          %a on *:input:!: $+ $chr(123) $chr(125)
        }
      }
      elseif (%e == open) {
        ; same as input, but for openuser, openchat, openserv
        if (!$fline(%wine, 3 openuser *, 1)) {
          %a on *:open:?: $+ $chr(123) $chr(125)
        }
        if (!$fline(%wine, & openchat *, 1)) {
          %a on *:open:=: $+ $chr(123) $chr(125)
        }
        if (!$fline(%wine, & openserv *, 1)) {
          %a on *:open:!: $+ $chr(123) $chr(125)
        }
      }
      elseif (%e == close) {
        ; same as input, but for openuser, openchat, openserv
        if (!$fline(%wine, & closeuser *, 1)) {
          %a on *:close:?: $+ $chr(123) $chr(125)
        }
        if (!$fline(%wine, & closechat *, 1)) {
          %a on *:close:=: $+ $chr(123) $chr(125)
        }
        if (!$fline(%wine, & closeserv *, 1)) {
          %a on *:close:!: $+ $chr(123) $chr(125)
        }
      }
      if ($istok(%suffixedevents, %e, 32)) {
        %reale = $left(%e, -4)
      }
      else {
        %reale = %e
      }
      %isalias = 0
      %israw = 0
      ; ###### <Kamek!20106> we must add on HOTLINK and on ^HOTLINK
      ; other missing ones: on KEYUP, KEYDOWN, SIGNAL
      ; do not add: on DIALOG, SOCKOPEN, SOCKREAD, SOCKWRITE, SOCKCLOSE, SOCKLISTEN, UDPREAD
      if ($istok(ctcpchan, %e, 32)) {
        %header = event *:*:#:
      }
      elseif ($istok(ctcpuser, %e, 32)) {
        %header = event *:*:?:
      }
      elseif ($istok(actionchan noticechan textchan, %e, 32)) {
        %header = on *:event:*:#:
      }
      elseif ($istok(actionuser noticeuser textuser, %e, 32)) {
        %header = on *:event:*:?:
      }
      elseif ($istok(openuser, %e, 32)) {
        %header = on *:event:?:*:
      }
      elseif ($istok(vcmd, %e, 32)) {
        %header = on *:event:*:*:
      }
      elseif ($istok(%chanevents, %e, 32)) {
        %header = on *:event:#:
      }
      elseif ($istok(openchat inputchat closechat, %e, 32)) {
        %header = on *:event:=:
      }
      elseif ($istok(openserv inputserv closeserv, %e, 32)) {
        %header = on *:event:!:
      }
      elseif ($istok(inputuser closeuser, %e, 32)) {
        %header = on *:event:?:
      }
      elseif ($istok(%genparmevents, %e, 32)) {
        %header = on *:event:*:
      }
      elseif ($istok(%noparmevents, %e, 32)) {
        %header = on *:event:
      }
      elseif (raw_* iswm %e) {
        %header = raw $mid(%e, 5) $+ :*:
        %israw = 1
      }
      elseif (?*_?* iswm %e) || ($istok(start exit raw moduleload moduleunload, %e, 32)) {
        %header = alias airc_hook_event
        %isalias = 1
      }
      else {
        var %header
      }
      if (%isalias) || (raw_* iswm %e) || ($istok(%hasparmidsevents, %reale, 32)) {
        %hasparmids = 1
      }
      else {
        %hasparmids = 0
      }
      if (%header) {
        ; only prefix with ^ if the remote can be halted
        if (o isincs $gettok(%ln, 3, 32)) && ($istok(%haltdefault, %e, 32)) {
          %header = on ^ $+ $gettok(%header, 2-, 32)
        }
        if (%isalias) {
          %a $replace(%header, event, %reale) $chr(123)
        }
        else {
          %a $replace(%header, event, %reale) $+ $chr(123)
        }
        %open = 1
        if (%hasparmids) {
          %a set -n % $+ airc_parms $!1-
        }
      }
      %added_general_hook = 0
    }
    if (%header) && (%open) {
      if ($istok(inputchan inputuser inputchat inputserv input, %e, 32)) && (t isincs $gettok(%ln, 3, 32)) && (%open = 1) {
        %a if (!$halted) && (!$inpaste) && ((/* !iswm $+($,1-) ) || ($ctrlenter)) $chr(123)
        inc %open
      }
      elseif (raw_* iswm %e) && (e isincs $gettok(%ln, 3, 32)) && (%has_general_raw) && (!%added_general_hook) {
        %a var % $+ airc__parms %| set -n % $+ airc__parms % $+ airc_parms %| airc_hook_raw % $+ airc_parms %| set -n % $+ airc_parms % $+ airc__parms
        %added_general_hook = 1
      }
      %a %code
    }
    %laste = %cure
    inc %i
    inc %j
  }
  if (%open) {
    %le = %e
    %returnpoint = returnpoint2
    goto close
    :returnpoint2
  }
  if (%has_general_raw) {
    %a raw *:*:airc_hook_raw $!1-
  }

  ; part 3: close everything, load the file that was created

  ; ###### <tabo!20718> saving all the merged amdsections to $airc_usrdir(<section>.dat)
  ; ###### <Kamek!20723> changed to <section>.ams, to make it more clear
  %j = $numtok(%amdsections, 32)
  while (%j) {
    var %asu = $gettok(%amdsections, %j, 32), %asw = $+(@airc_buildevents_, %asu)
    filter -cwwt 1 32 %asw %asw *
    savebuf %asw $airc_usrdir($+(%asu, .ams))
    close -@ %asw
    dec %j
  }

  ; adding a header comment to events.mrc
  iline %winc 1 ; ### events $airc_vertag $asctime

  savebuf %winc $airc_usrdir(events.mrc)
  close -@ %wine %winc
  .reload -rs $+ $calc($script(0) + 1) $airc_usrdir(events.mrc)
  return

  :close
  if ($istok(inputchan inputuser inputchat inputserv input, %le, 32)) {
    var %condition
    if (%open == 1) {
      %condition = (!$halted) && ((/* !iswm $+($,1-) ) || ($ctrlenter) || ($inpaste))
    }
    else {
      %condition = (!$halted)
    }
    if (%le == input) {
      %condition = %condition && (($target ischan) || ($query($target)) || (=* iswm $!target))
    }
    %a if %condition && ($gettok(%airc_parms, 1-, 32) !=== $!1-) $chr(123) msg $!target % $+ airc_parms %| halt $chr(125)
  }
  while (%open > 1) {
    %a $chr(125)
    dec %open
  }
  ; if it was a raw, we must then call the general raw
  ; NOTE: this is a direct call to the alias, for speed purposes.
  ; another note... %airc_parms won't be unset this way, because it will be unset by the general raw
  if (%israw) && (%has_general_raw) && (!%added_general_hook) {
    %a airc_hook_raw % $+ airc_parms
  }
  ; we must unset %airc_parms first
  elseif (%isalias) {
    %a var % $+ parms %| set -n % $+ parms % $+ airc_parms %| unset % $+ airc_parms %| return % $+ parms
  }
  elseif (%hasparmids) {
    %a unset % $+ airc_parms
  }
  %a $chr(125)
  %open = 0
  goto %returnpoint
}
alias -l airc_buildevents_sort {
  var %n1 = $gettok($1, 1, 32), %n2 = $gettok($2, 1, 32), %e1 = $gettok($1, 2, 32), %e2 = $gettok($2, 2, 32)
  if (%n1 = 9) && (%n2 = 9) && (%e1 == %e2) {
    var %f1 = $gettok($1, 4, 32), %f2 = $gettok($2, 4, 32)
    if (e isincs %f1) && (e !isincs %f2) {
      return 1
    }
    if (e !isincs %f1) && (e isincs %f2) {
      return -1
    }
  }
  if (%n1 > %n2) {
    return 1
  }
  if (%n1 < %n2) {
    return -1
  }
  if (%e1 > %e2) {
    return 1
  }
  if (%e1 < %e2) {
    return -1
  }
  %n1 = $gettok($1, 3, 32)
  %n2 = $gettok($2, 3, 32)
  if (%n1 > %n2) {
    return 1
  }
  if (%n1 < %n2) {
    return -1
  }
  return 0
}



alias airc_buildmods {
  var %w1 = @airc_merge, %w2 = @airc_merge_tmp, %w3 = @airc_merge_blah, %i = 1, %file, %ticks = $ticks
  close -@ %w1 %w2 %w3
  window -hl %w1
  window -hl %w2
  window -hl %w3
  echo $color(info) -qati2 *** $iif($aircdebug, Loading module files..., Merging modules...)
  ; first, get all files
  while ($airc_modget(%i)) {
    aline %w3 $readini($airc_id2file($ifmatch), n, module, scriptfiles)
    inc %i
  }
  ; now, merge them
  %i = 1
  while ($line(%w3, %i)) {
    %file = $longfn($airc_moddir($ifmatch))
    ; ###### <tabo!20323> using airc_mod2merged
    if ($isfile(%file)) {
      airc_mod2merged %w2 %w1 %file
    }
    inc %i
  }
  if ($aircdebug) {
    .unload -rs $airc_usrdir(modcode.mrc)
    .remove $airc_usrdir(modcode.mrc)
  }
  else {
    airc_modcode_savereload %w1 $airc_usrdir(modcode.mrc)
  }
  ; cleanup
  close -@ %w1 %w2 %w3
  echo $color(info) -qati2 *** $iif($aircdebug, Module files loaded, Modules merged) in $calc(($ticks - %ticks) / 1000) s
}

; /airc_modcode_savereload <@window> <file>
alias -l airc_modcode_savereload {
  var %str = ; ### modcode $airc_vertag $asctime
  if ($gettok($line($1, 1), 1-3, 32) == ; ### modcode) {
    rline $1 1 %str
  }
  else {
    iline $1 1 %str
  }
  savebuf $1 $2-
  .reload -rs2 $2-
}

; airc_mod2merged tmpwin win file
alias -l airc_mod2merged {
  if ($aircdebug) {
    .load -rs $+(", $3-, ")
  }
  else {
    ; load the file in the temp window (%w2), without comments or blank lines
    filter -cxgfw $+(", $3-, ") $1 /^\x20*(;.*)?$/
    ; take out headers
    if ($fline($1, #aircmodule end, 1)) {
      dline $1 1- $+ $ifmatch
    }
    ; now, pass everything to the main window
    ; ###### <tabo!20323> using relative paths now
    aline $2 ; ### begin $remove($3-, $mircdir)
    filter -ww $1 $2
    aline $2 ; ### end $remove($3-, $mircdir)
    ; ###### <tabo!20323> unload the file if it's loaded in remotes
    if ($script($3-)) {
      .unload -rs $+(", $ifmatch, ")
    }
  }
}

; ###### <tabo!30531> I know this mod-specific hack is ugly, but we're still in alpha right?
alias -l airc_allmodulesinorder {
  return stdlib stdio evaltext queue mdx cpanel op users timer settings ial ibl lag flood punish pprot cprot pprotsetup cprotsetup kncomp menus trayman fkeys klagbar kte away channels emi mailchk trayplayer settingsd tlsbncman tlsamdman
}

; /aircdebug [on|off]
;   Sets on|off the debug mode in the script. When debug mode is off (normal
;   mode), all the modules will be merged in a single file, so you'll have only
;   one big file loaded. All the modifications to this file will be lost the
;   next time you load/unload a module. When debug mode is on, the module files
;   will be /load-rs'ed to mirc, it's safe to script in this mode.
;   When called as an identifier, this function will return 0|1 depending if
;   debug mode is on|off
alias aircdebug {
  var %old = $iif($airc_get(main, debug), 1, 0), %cur = %old
  if ($isid) {
    return %old
  }
  if ($istok(on off, $1, 32)) {
    %cur = $iif($1 == on, 1, 0)
    airc_set main debug %cur
  }
  if (%old != %cur) {
    airc_buildmods
  }
  echo $color(info) -qati2 *** airc debug is $iif(%cur, ON, OFF)
  return %cur
}

; /all [-atM] <command>
;   When used without the switches, performs the command in all the open
;   sessions as if it was typed in every one of them. When used with switches
;   it works as a shortcut to /scid, with the bonus that it will /scid -r after
;   the command is executed (useful if you're as paranoid as me and think that
;   /scid has a life of it's own and gets completly weird sometimes).
alias all {
  scid $iif($1 !isnum && -* !iswm $1, -a) $1-
  scid -r
}

; /findcmds
;   The ultra secret function that nobody knows about, if you're not Kamek or tabo, stop
;   reading or we'll have to kill you. It's so secret that I won't say what it does.
alias findcmds {
  var %winU = @findcmdsU, %winE = @findcmdsE, %winI = @findcmdsI, %winT = @findcmdsT, %i, %t
  close -@ %winU %winE %winI %winT
  window -hl %winU
  window -hl %winE
  window -hl %winI
  window -hl %winT
  airc_findcmds airc.mrc
  %t = $findfile($mircdirmod\, *, 0, airc_findcmds $1-)
  savebuf %winU functionsU.txt
  savebuf %winE functionsE.txt
  savebuf %winI functionsI.txt
  close -@ %winU %winE %winI %winT
}
alias -l airc_findcmds {
  var %win = @findcmdsT, %i = 1, %n, %t, %m = $gettok($nopath($1-), 1, 46), %f
  clear %win
  window -hl %win
  filter -fw " $+ $1- $+ " %win alias *
  %n = $line(%win, 0)
  while (%i <= %n) {
    %t = $line(%win, %i)
    %f = $gettok(%t, 2, 32)
    if (%f == -l) {
      aline @findcmdsI %m $gettok(%t, 3, 32)
    }
    elseif (_* iswm %f || ($numtok(%f, 95) > 1 && $gettok(%f, 1, 95) == %m)) {
      aline @findcmdsE %m %f
    }
    else {
      aline @findcmdsU %m %f
    }
    inc %i
  }
}
alias clearall {
  !clearall $iif(($0), $1-, -snqmtg)
}




;
